/*
  ==============================================================================

    This file was auto-generated!

  ==============================================================================
*/

#ifndef __MAINCOMPONENT_H_4914D443__
#define __MAINCOMPONENT_H_4914D443__

#include "../JuceLibraryCode/JuceHeader.h"
#include "OSCThread.h"

//==============================================================================
/*
    This component lives inside our window, and this is where you should put all
    your controls and content.
*/
class MainContentComponent   : public Component
{
public:
    //==============================================================================
    MainContentComponent();
    ~MainContentComponent();

    void paint (Graphics&);
    void resized();

	///	Used to add ports to the patcher from the GameListPanel.
	void addGameToPatcher(const String& gameName,
						  const String& listenPort,
						  const String& sendAddress,
						  const String& sendPort);

	///	Adds a new listen port for patching.
	void addListenPort(int port);
	///	Sets the port of the indexed listen socket.
	void setListenPort(int index, int port);
	///	Returns the port of the indexed listen socket.
	int getListenPort(int index) const {return oscThreads[index]->getListenPort();};

	///	Adds a send destination to the indexed thread.
	void addSendDestination(int index, const String& address, int port);
	///	Removes a send destination from the indexed thread.
	void removeSendDestination(int threadIndex,
							   const String& address,
							   int port);

	///	Sets the indexed send port of the indexed thread.
	void setSendPort(int threadIndex, int destIndex, int port);
	///	Sets the indexed send address.
	void setSendAddress(int threadIndex, int destIndex, const String& address);

    /// Struct holding the relevant details about our games.
    struct GameDetails
    {
        /// The game's name.
        String name;
        /// The game's author(s).
        String authors;
        /// The game's description.
        String description;
        /// The game's screenshot.
        Image screenshot;
        /// The game's executable.
        File executable;
    };
    
    /// Returns the GameDetails array.
    const OwnedArray<GameDetails>& getGames() const {return games;};

private:
    //==============================================================================
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (MainContentComponent)

    /// Helper method. Fills out the games array.
    void discoverGames();

    /// Everything lives inside this TabbedComponent.
    ScopedPointer<TabbedComponent> mainTabs;
    /// This label displays the computer's ip address.
    ScopedPointer<Label> ipAddressLabel;

    /// Holds all our GameDetails.
    OwnedArray<GameDetails> games;

	///	All the OSCThreads we have running.
	OwnedArray<OSCThread> oscThreads;
};


#endif  // __MAINCOMPONENT_H_4914D443__
